//
//  main.swift
//
//    Given a 2D board and a word, find if the word exists in the grid.
//
//    The word can be constructed from letters of sequentially adjacent cell, where "adjacent" cells are those horizontally or vertically neighboring. The same letter cell may not be used more than once.
//
//    For example,
//    Given board =
//
//    [
//      ["ABCE"],
//      ["SFCS"],
//      ["ADEE"]
//    ]
//    word = "ABCCED", -> returns true,
//    word = "SEE", -> returns true,
//    word = "ABCB", -> returns false.
//
//  Created by Guan Gui on 19/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func iterativeExist(board: [[UInt8]], word: [UInt8]) -> Bool {
    if word.count == 0 {
        return true
    }
    var prevPoses: [Int:Void] = [:] // Use Dictionary as a hashset
    struct Frame {
        var pos: (x: Int, y: Int)
        var dir: Int
    }
    var stack: [Frame] = []
    var currWordPos = 0
    var pos: (x: Int, y: Int) = (-1, -1)
    var dir = 0
    func popLastFrame() {
        let currFrame = stack.removeLast()
        pos = currFrame.pos
        prevPoses[combine(pos)] = nil
        dir = currFrame.dir + 1
        --currWordPos
    }
    func searchPos(newPos: (Int, Int), oldDir: Int) {
        prevPoses[combine(pos)] = ()
        stack.append(Frame(pos: pos, dir: oldDir))
        pos = newPos
        dir = 0
        ++currWordPos
    }
    for var i = 0; i < board.count; ++i {
        for var j = 0; j < board[0].count; ++j {
            pos = (j, i)
            search: while true {
                if prevPoses[combine(pos)] != nil || board[pos.y][pos.x] != word[currWordPos] {
                    if stack.count == 0 {
                        break search
                    } else {
                        popLastFrame()
                    }
                }
                if currWordPos == word.count - 1 {
                    return true
                }

                switch dir {
                case 0:
                    if pos.y > 0 {
                        searchPos((pos.x, pos.y - 1), 0)
                        continue search
                    }
                    fallthrough
                case 1:
                    if pos.x < board[0].count - 1 {
                        searchPos((pos.x + 1, pos.y), 1)
                        continue search
                    }
                    fallthrough
                case 2:
                    if pos.y < board.count - 1 {
                        searchPos((pos.x, pos.y + 1), 2)
                        continue search
                    }
                    fallthrough
                case 3:
                    if pos.x > 0 {
                        searchPos((pos.x - 1, pos.y), 3)
                        continue search
                    }
                    fallthrough
                default:
                    if stack.count == 0 {
                        break search
                    } else {
                        popLastFrame()
                    }
                }
            }
            dir = 0
        }
    }
    return false
}

func recursiveExist(var board: [[UInt8]], var word: [UInt8]) -> Bool {
    if word.count == 0 {
        return true
    }
    var prevPoses: [Int:Void] = [:] // Use Dictionary as a hashset
    for var i = 0; i < board.count; ++i {
        for var j = 0; j < board[0].count; ++j {
            if _recursiveExist((j, i), &board, &word, 0, &prevPoses) {
                return true
            }
        }
    }
    return false
}

func _recursiveExist(pos: (x: Int, y: Int), inout board: [[UInt8]], inout word: [UInt8], currWordPos: Int, inout prevPoses: [Int:Void]) -> Bool {
    let combinedPos = combine(pos)
    if prevPoses[combinedPos] != nil || board[pos.y][pos.x] != word[currWordPos] {
        return false
    }
    if currWordPos == word.count - 1 {
        return true
    }
    
    prevPoses[combinedPos] = ()
    if pos.y > 0 {
        if _recursiveExist((pos.x, pos.y - 1), &board, &word, currWordPos + 1, &prevPoses) {
            return true
        }
    }
    if pos.x < board[0].count - 1 {
        if _recursiveExist((pos.x + 1, pos.y), &board, &word, currWordPos + 1, &prevPoses) {
            return true
        }
    }
    if pos.y < board.count - 1 {
        if _recursiveExist((pos.x, pos.y + 1), &board, &word, currWordPos + 1, &prevPoses) {
            return true
        }
    }
    if pos.x > 0 {
        if _recursiveExist((pos.x - 1, pos.y), &board, &word, currWordPos + 1, &prevPoses) {
            return true
        }
    }
    prevPoses[combinedPos] = nil
    return false
}

func combine(pos: (x: Int, y: Int)) -> Int {
    return pos.x << 32 | pos.y
}

extension Character {
    func utf8Value() -> UInt8 {
        for s in String(self).utf8 {
            return s
        }
        return 0
    }
    
    func utf16Value() -> UInt16 {
        for s in String(self).utf16 {
            return s
        }
        return 0
    }
    
    func unicodeValue() -> UInt32 {
        for s in String(self).unicodeScalars {
            return s.value
        }
        return 0
    }
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
var timer1 = NanoTimer(), timer2 = NanoTimer()

for (index, testCase) in json {
    var board = testCase["input"]["board"].asArray!.map{ Array($0.asString!).map{ $0.utf8Value() } }
    var word = Array(testCase["input"]["word"].asString!).map{ $0.utf8Value() }
    var output = testCase["output"].asBool!
    
    timer1.start()
    var actualOutput1 = recursiveExist(board, word)
    timer1.stop()
    
    timer2.start()
    var actualOutput2 = iterativeExist(board, word)
    timer2.stop()
    
    if actualOutput1 == output && actualOutput2 == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs (recursively) %fs (iteratively)", arguments: [timer1.seconds, timer2.seconds]))

