//
//  main.swift
//
//    Sort a linked list in O(n log n) time using constant space complexity.
//
//  Created by Guan Gui on 9/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

class ListNode {
    var val: Int
    var next: ListNode?
    init(val: Int) {
        self.val = val
    }
    convenience init(val: Int, next: ListNode) {
        self.init(val: val)
        self.next = next
    }
}

func sortList(var head: ListNode?) -> ListNode? {
    var size = -1, count = 0
    var step = 1
    var leftListNode: ListNode? = head
    var rightListNode: ListNode? = leftListNode
    var lastMergeNode: ListNode? = nil
    
    while size < 0 || step < size {
        // find rightListHead
        var i = step
        while rightListNode != nil && i > 0 {
            rightListNode = rightListNode!.next
            --i
            if size < 0 {
                --size
            }
        }
        if rightListNode == nil {
            // reaches the end
            if size < 0 {
                size = -size - 1
            }
            step *= 2
            leftListNode = head
            rightListNode = leftListNode
            lastMergeNode = nil
        } else {
            // start merge
            var i = step, j = step
            while i > 0 || j > 0 {
                var node: ListNode
                
                if (i > 0 && j > 0 && leftListNode!.val <= rightListNode!.val) || j == 0 {
                    node = leftListNode!
                    if i > 1 {
                        leftListNode = leftListNode!.next
                    }
                    --i
                } else {
                    node = rightListNode!
                    rightListNode = rightListNode!.next
                    if rightListNode == nil {
                        j = 0
                    } else {
                        --j
                    }
                    if size < 0 {
                        --size
                    }
                }
                
                if lastMergeNode != nil {
                    lastMergeNode!.next = node
                } else {
                    head = node
                }
                lastMergeNode = node
            }
            leftListNode = rightListNode
            lastMergeNode!.next = rightListNode
        }
    }
    
    return head
}

func listToString(var head: ListNode?) -> String {
    var result = "{"
    while head != nil {
        result += String(head!.val)
        head = head!.next
        if head != nil {
            result += ","
        }
    }
    result += "}"
    return result
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
let regex = NSRegularExpression.regularExpressionWithPattern("-?\\d+", options: nil, error: nil)!
var timeElapsed:CFAbsoluteTime = 0
for (index, testCase) in json {
    let c = testCase["input"].asString! as NSString
    var matches = regex.matchesInString(c, options: nil, range: NSMakeRange(0, c.length))
    var input: ListNode?
    var prevNode: ListNode? = input
    for m in matches {
        let val = c.substringWithRange(m.rangeAtIndex(0)).toInt()!
        let currNode = ListNode(val: val)
        if prevNode != nil {
            prevNode!.next = currNode
        } else {
            input = currNode
        }
        prevNode = currNode
    }
    
    var output = testCase["output"].asString
    
    let startTime = CFAbsoluteTimeGetCurrent()
    var rawActualOutput = sortList(input)
    timeElapsed += CFAbsoluteTimeGetCurrent() - startTime
    
    let actualOutput = listToString(rawActualOutput)
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs", arguments: [timeElapsed]))