//
//  main.swift
//
//    Given a sorted array and a target value, return the index if the target is found. If not, return the index where it would be if it were inserted in order.
//
//    You may assume no duplicates in the array.
//
//    Here are few examples.
//    [1,3,5,6], 5 → 2
//    [1,3,5,6], 2 → 1
//    [1,3,5,6], 7 → 4
//    [1,3,5,6], 0 → 0
//
//  Created by Guan Gui on 13/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func searchInsert(A: [Int], target: Int) -> Int {
    var leftIndex = 0, rightIndex = A.count - 1, midIndex: Int
    do {
        midIndex = (leftIndex + rightIndex) / 2
        if target == A[midIndex] {
            return midIndex
        } else if target < A[midIndex] {
            rightIndex = midIndex - 1
        } else {
            leftIndex = midIndex + 1
        }
    } while (leftIndex <= rightIndex)
    return leftIndex
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
var timer = NanoTimer()

for (index, testCase) in json {
    var A = testCase["input"]["A"].asArray!.map({ c -> Int in
        return c.asInt!
    })
    var target = testCase["input"]["target"].asInt!
    var output = testCase["output"].asInt!
    
    timer.start()
    var actualOutput = searchInsert(A, target)
    timer.stop()
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %.9fs", arguments: [timer.seconds]))