//
//  main.swift
//
//    Given an input string, reverse the string word by word.
//
//    For example,
//    Given s = "the sky is blue",
//    return "blue is sky the".
//        
//    Clarification:
//    What constitutes a word?
//    A sequence of non-space characters constitutes a word.
//    Could the input string contain leading or trailing spaces?
//    Yes. However, your reversed string should not contain leading or trailing spaces.
//    How about multiple spaces between two words?
//    Reduce them to a single space in the reversed string.
//
//  Created by Guan Gui on 26/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func reverseWords(s: String) -> String {
    var tmp = s.componentsSeparatedByCharactersInSet(NSCharacterSet.whitespaceCharacterSet())
    tmp = tmp.filter{ $0 != "" }.reverse()
    return " ".join(tmp)
}

// Do It Yourself Version
//func reverseWords(s: String) -> String {
//    var newS: String = ""
//    var bufferS: String = ""
//    func joinBufferS() {
//        if !bufferS.isEmpty {
//            let midS = newS.isEmpty ? "" : " "
//            newS = bufferS + midS + newS
//            bufferS = ""
//        }
//    }
//    for c in s {
//        if String(c) == " " {
//            joinBufferS()
//        } else {
//            bufferS += String(c)
//        }
//    }
//    joinBufferS()
//    return newS
//}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
var timer = NanoTimer()

for (index, testCase) in json {
    var input = testCase["input"].asString!
    var output = testCase["output"].asString!
    
    timer.start()
    var actualOutput = reverseWords(input)
    timer.stop()
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %.6fs", arguments: [timer.seconds]))