//
//  main.swift
//
//    Given n points on a 2D plane, find the maximum number of points that lie on the same straight line.
//
//  Created by Guan Gui on 8/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func maxPoints(points: [(Int, Int)]) -> Int {
    var lines: [Double:Int] = Dictionary(minimumCapacity: points.count)
    var maxNum = 0
    for var i = 0; i < points.count - maxNum; ++i {
        var curMaxNum = 1
        var sameCount = 0
        for var j = i + 1; j < points.count; ++j {
            let (x1, y1) = points[i]
            let (x2, y2) = points[j]
            
            if x1 == x2 && y1 == y2 {
                sameCount++
            } else {
                let slope: Double = x2 == x1 ? Double.infinity : Double(y2 - y1) / Double(x2 - x1)
                var line: Int! = lines[slope]
                if line != nil {
                    lines[slope] = ++line!
                } else {
                    line = 2
                    lines[slope] = line
                }
                curMaxNum = max(line, curMaxNum)
            }
        }
        maxNum = max(maxNum, curMaxNum + sameCount)
        lines.removeAll(keepCapacity: true)
    }
    return maxNum
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
let regex = NSRegularExpression.regularExpressionWithPattern("\\((-?\\d+),(-?\\d+)\\)", options: nil, error: nil)!
var timeElapsed:CFAbsoluteTime = 0
for (index, testCase) in json {
    let c = testCase["input"].asString! as NSString
    var matches = regex.matchesInString(c, options: nil, range: NSMakeRange(0, c.length))
    var input:[(Int, Int)] = []
    for m in matches {
        let x = c.substringWithRange(m.rangeAtIndex(1)).toInt()!
        let y = c.substringWithRange(m.rangeAtIndex(2)).toInt()!
        input.append((x, y))
    }
    
    var output = testCase["output"].asInt
    
    let startTime = CFAbsoluteTimeGetCurrent()
    var actualOutput = maxPoints(input)
    timeElapsed += CFAbsoluteTimeGetCurrent() - startTime
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs", arguments: [timeElapsed]))