//
//  main.swift
//
//    Given a string S, find the longest palindromic substring in S. You may assume that the maximum length of S is 1000, and there exists one unique longest palindromic substring.
//
//  Created by Guan Gui on 16/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func longestPalindrome<T: Equatable>(s: [T]) -> [T] {
    var sLen = s.count
    var curPalLen = 0
    var palLens: [Int] = []
    var maxPal = (idx: -1, len: -1)
    var i = 0
    var updateMaxPal = { () -> () in
        if curPalLen > maxPal.len {
            maxPal = (palLens.count, curPalLen)
        }
    }
    outer: while i < sLen {
        // find the longest palindrome centered at current center position, i.e. 
        // palLens.count
        if i > curPalLen && s[i] == s[i - curPalLen - 1] {
            ++i
            curPalLen += 2
            continue
        }
        updateMaxPal()
        palLens.append(curPalLen)
        // move to next center
        //
        // we can do this either naively by just moving to next center position 
        // of 2*n + 1 positions one by one:
        //      i = (palLens.count - 1) / 2 + 1
        //      palLen = palLens.count % 2
        //
        // or we could take advantage of the palindrome symmetry:
        //      a b a b a b a b a
        //     0103050709070503010
        //     |
        //     |? ? ? ? ? ? ? ? ?
        //     0??????????????????
        //      |
        //      a|? ? ? ? ? ? ? ?
        //     01?????????????????
        //       |
        //      a|? ? ? ? ? ? ? ?
        //     010????????????????
        //        |
        //      a b a|? ? ? ? ? ?
        //     0103???????????????
        //          |
        //      a b a b a|? ? ? ?
        //     010305?????????????
        //            |
        //      a b a b a b a|? ?
        //     01030507???????????
        //              |
        //      a b a b a b a b a|
        //     0103050709?????????
        let curPalLeftHalfStartIdx = palLens.count - 1 - curPalLen
        let curPalLeftHalfEndIdx = palLens.count - 2
        for var j = curPalLeftHalfEndIdx; j >= curPalLeftHalfStartIdx; --j {
            let distToLeftEdge = j - curPalLeftHalfStartIdx
            if palLens[j] == distToLeftEdge {
                curPalLen = distToLeftEdge
                continue outer
            }
            palLens.append(min(distToLeftEdge, palLens[j]))
        }
        curPalLen = 1
        ++i
    }
    updateMaxPal()
    let startIdx = maxPal.idx / 2 - maxPal.len / 2
    return Array(s[startIdx..<startIdx + maxPal.len])
}

extension Character {
    func utf8Value() -> UInt8 {
        for s in String(self).utf8 {
            return s
        }
        return 0
    }
    
    func utf16Value() -> UInt16 {
        for s in String(self).utf16 {
            return s
        }
        return 0
    }
    
    func unicodeValue() -> UInt32 {
        for s in String(self).unicodeScalars {
            return s.value
        }
        return 0
    }
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
var timer = NanoTimer()

for (index, testCase) in json {
    var input = Array(testCase["input"].asString!).map{ $0.utf8Value() }
    var output = Array(testCase["output"].asString!).map{ $0.utf8Value() }
//    var input = Array(testCase["input"].asString!)
//    var output = Array(testCase["output"].asString!)
    
    timer.start()
    var actualOutput = longestPalindrome(input)
    timer.stop()
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %.6fs", arguments: [timer.seconds]))