//
//  main.swift
//
//    Given n non-negative integers representing the histogram's bar height where the width of each bar is 1, find the area of largest rectangle in the histogram.
//
//    http://www.leetcode.com/wp-content/uploads/2012/04/histogram.png
//
//    Above is a histogram where width of each bar is 1, given height = [2,1,5,6,2,3].
//
//    http://www.leetcode.com/wp-content/uploads/2012/04/histogram_area.png
//
//    The largest rectangle is shown in the shaded area, which has area = 10 unit.
//
//    For example,
//    Given height = [2,1,5,6,2,3],
//    return 10.
//
//  Created by Guan Gui on 19/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func largestRectangleArea(heights: [Int]) -> Int {
    var widths = [Int](count: heights.count, repeatedValue: 1)
    var stack: [Int] = []
    var largestRectangleArea = 0
    // calc left half of width for each reference histogram bar
    for var i = 0; i < heights.count; ++i {
        while let sIdx = stack.last {
            if heights[sIdx] < heights[i] {
                break
            }
            stack.removeLast()
        }
        if let sIdx = stack.last {
            widths[i] += i - sIdx - 1
        } else {
            widths[i] += i
        }
        stack.append(i)
    }
    stack.removeAll(keepCapacity: true)
    // calc right half of width for each reference histogram bar while find out
    // the largest rectangle
    for var i = heights.count - 1; i >= 0; --i {
        while let sIdx = stack.last {
            if heights[sIdx] < heights[i] {
                break
            }
            stack.removeLast()
        }
        if let sIdx = stack.last {
            widths[i] += sIdx - i - 1
        } else {
            widths[i] += heights.count - 1 - i
        }
        stack.append(i)

        largestRectangleArea = max(widths[i] * heights[i], largestRectangleArea)
    }
    return largestRectangleArea
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
var timer = NanoTimer()

for (index, testCase) in json {
    var input = testCase["input"].asArray!.map{ $0.asInt! }
    var output = testCase["output"].asInt!
    
    timer.start()
    var actualOutput = largestRectangleArea(input)
    timer.stop()
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %.6fs", arguments: [timer.seconds]))