//
//  main.swift
//  
//    Sort a linked list using insertion sort.
//
//  Created by Guan Gui on 12/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

class ListNode {
    var val: Int
    var next: ListNode?
    init(val: Int) {
        self.val = val
    }
    convenience init(val: Int, next: ListNode) {
        self.init(val: val)
        self.next = next
    }
}

func insertionSortList(var head: ListNode?) -> ListNode? {
    if head == nil {
        return head
    }
    var currRemainingNode = head!.next
    var nextRemainingNode = currRemainingNode?.next
    head!.next = nil
    var prevNode: ListNode? = nil
    var currNode = head
    while currRemainingNode != nil {
        while (true) {
            if currRemainingNode!.val >= currNode!.val {
                prevNode = currNode
                currNode = currNode!.next
                if currNode == nil {
                    prevNode!.next = currRemainingNode
                    currRemainingNode!.next = nil
                    currNode = currRemainingNode
                    break;
                }
            } else if prevNode != nil && currRemainingNode!.val < prevNode!.val {
                // restart search from beginning
                prevNode = nil
                currNode = head
            } else {
                currRemainingNode!.next = currNode
                currNode = currRemainingNode
                if prevNode != nil {
                    prevNode!.next = currRemainingNode
                } else {
                    head = currRemainingNode
                }
                break;
            }
        }
        currRemainingNode = nextRemainingNode
        nextRemainingNode = nextRemainingNode?.next
    }
    return head
}

func listToString(var head: ListNode?) -> String {
    var result = "{"
    while head != nil {
        result += String(head!.val)
        head = head!.next
        if head != nil {
            result += ","
        }
    }
    result += "}"
    return result
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
let regex = NSRegularExpression.regularExpressionWithPattern("-?\\d+", options: nil, error: nil)!
var timeElapsed:CFAbsoluteTime = 0
for (index, testCase) in json {
    let c = testCase["input"].asString! as NSString
    var matches = regex.matchesInString(c, options: nil, range: NSMakeRange(0, c.length))
    var input: ListNode?
    var prevNode: ListNode? = input
    for m in matches {
        let val = c.substringWithRange(m.rangeAtIndex(0)).toInt()!
        let currNode = ListNode(val: val)
        if prevNode != nil {
            prevNode!.next = currNode
        } else {
            input = currNode
        }
        prevNode = currNode
    }
    
    var output = testCase["output"].asString
    
    let startTime = CFAbsoluteTimeGetCurrent()
    var rawActualOutput = insertionSortList(input)
    timeElapsed += CFAbsoluteTimeGetCurrent() - startTime
    
    let actualOutput = listToString(rawActualOutput)
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs", arguments: [timeElapsed]))