//
//  main.swift
//
//    Evaluate the value of an arithmetic expression in Reverse Polish Notation.
//
//    Valid operators are +, -, *, /. Each operand may be an integer or another expression.
//
//    Some examples:
//    ["2", "1", "+", "3", "*"] -> ((2 + 1) * 3) -> 9
//    ["4", "13", "5", "/", "+"] -> (4 + (13 / 5)) -> 6
//
//  Created by Guan Gui on 2/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

func evalRPN(tokens: [String]) -> Int {
    var stack = [String]()
    for s in tokens {
        switch s {
        case "+":
            var rightOperand = stack.removeLast().toInt()!
            var leftOperand = stack.removeLast().toInt()!
            stack.append(String(leftOperand + rightOperand))
        case "-":
            var rightOperand = stack.removeLast().toInt()!
            var leftOperand = stack.removeLast().toInt()!
            stack.append(String(leftOperand - rightOperand))
        case "*":
            var rightOperand = stack.removeLast().toInt()!
            var leftOperand = stack.removeLast().toInt()!
            stack.append(String(leftOperand * rightOperand))
        case "/":
            var rightOperand = stack.removeLast().toInt()!
            var leftOperand = stack.removeLast().toInt()!
            stack.append(String(leftOperand / rightOperand))
        default:
            stack.append(s)
        }
    }
    return stack.removeLast().toInt()!
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
var timeElapsed:CFAbsoluteTime = 0
for (index, testCase) in json {
    var input = testCase["input"].asArray!.map({ c -> String in
        return c.asString!
    })
    var output = testCase["output"].asInt
    
    let startTime = CFAbsoluteTimeGetCurrent()
    var actualOutput = evalRPN(input)
    timeElapsed += CFAbsoluteTimeGetCurrent() - startTime
    
    if actualOutput == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs", arguments: [timeElapsed]))