//
//  main.swift
//
//    Given a binary tree, return the bottom-up level order traversal of its nodes' values. (ie, from left to right, level by level from leaf to root).
//
//    For example:
//    Given binary tree {3,9,20,#,#,15,7},
//       3
//      / \
//     9  20
//       /  \
//      15   7
//    return its bottom-up level order traversal as:
//    [
//      [15,7],
//      [9,20],
//      [3]
//    ]
//
//  Created by Guan Gui on 15/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

class TreeNode {
    var val: Int
    var left: TreeNode?
    var right: TreeNode?
    init(val: Int) {
        self.val = val
    }
    convenience init(val: Int, left: TreeNode?, right: TreeNode?) {
        self.init(val: val)
        self.left = left
        self.right = right
    }
}

func recursiveLevelOrderBottom(root: TreeNode?) -> [[Int]] {
    if root == nil {
        return []
    }
    return _recursiveLevelOrderBottom([root!], [])
}

func _recursiveLevelOrderBottom(queue: [TreeNode], resultSoFar: [[Int]]) -> [[Int]] {
    var result: [Int] = []
    var queueNext: [TreeNode] = []
    for node in queue {
        result.append(node.val)
        if node.left != nil {
            queueNext.append(node.left!)
        }
        if node.right != nil {
            queueNext.append(node.right!)
        }
    }
    if queueNext.count == 0 {
        return [result] + resultSoFar
    } else {
        return _recursiveLevelOrderBottom(queueNext, [result] + resultSoFar)
    }
}

func iterativeLevelOrderBottom(root: TreeNode?) -> [[Int]] {
    if root == nil {
        return []
    }
    var output: [[Int]] = []
    var result: [Int] = []
    var queue: [TreeNode] = [root!]
    var queueNext: [TreeNode] = []
    while queue.count > 0 {
        for node in queue {
            result.append(node.val)
            if node.left != nil {
                queueNext.append(node.left!)
            }
            if node.right != nil {
                queueNext.append(node.right!)
            }
        }
        output.insert(result, atIndex: 0)
        result.removeAll(keepCapacity: true)
        queue = queueNext
        queueNext.removeAll(keepCapacity: true)
    }
    return output
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
let regex = NSRegularExpression.regularExpressionWithPattern("-?\\d+|#", options: nil, error: nil)!
var timer1 = NanoTimer(), timer2 = NanoTimer()

for (index, testCase) in json {
    let c = testCase["input"].asString! as NSString
    var matches = regex.matchesInString(c, options: nil, range: NSMakeRange(0, c.length))
    var input: TreeNode?
    let uninitNode = TreeNode(val: 0)
    var queue: [TreeNode] = []
    for m in matches {
        let val = c.substringWithRange(m.rangeAtIndex(0)).toInt()
        var newNode: TreeNode?
        if val != nil {
            newNode = TreeNode(val: val!, left: uninitNode, right: uninitNode)
            queue.append(newNode!)
        }
        if input == nil {
            input = newNode
        } else {
            if queue.first!.left === uninitNode {
                queue.first!.left = newNode
            } else if queue.first!.right === uninitNode {
                queue.first!.right = newNode
                queue.removeAtIndex(0)
            }
        }
    }
    for node in queue {
        if node.left === uninitNode {
            node.left = nil
        }
        if node.right === uninitNode {
            node.right = nil
        }
    }
    
    var output = testCase["output"].asArray!.map({ c -> [Int] in
        return c.asArray!.map({ c -> Int in
            return c.asInt!
        })
    })
    
    timer1.start()
    var actualOutput1 = recursiveLevelOrderBottom(input)
    timer1.stop()
    
    timer2.start()
    var actualOutput2 = iterativeLevelOrderBottom(input)
    timer2.stop()
    
    if actualOutput2 == output && actualOutput2 == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs (recursively) %fs (iteratively)", arguments: [timer1.seconds, timer2.seconds]))