//
//  main.swift
//
//    Given a binary tree, return the inorder traversal of its nodes' values.
//
//    For example:
//    Given binary tree {1,#,2,3},
//    1
//     \
//      2
//     /
//    3
//    return [1,3,2].
//        
//    Note: Recursive solution is trivial, could you do it iteratively?
//
//  Created by Guan Gui on 15/09/2014.
//  Copyright (c) 2014 Guan Gui. All rights reserved.
//

import Foundation

class TreeNode {
    var val: Int
    var left: TreeNode?
    var right: TreeNode?
    init(val: Int) {
        self.val = val
    }
    convenience init(val: Int, left: TreeNode?, right: TreeNode?) {
        self.init(val: val)
        self.left = left
        self.right = right
    }
}

func recursiveInorderTraversal(root: TreeNode?) -> [Int] {
    if root == nil {
        return []
    }
    var result: [Int] = []
    result += recursiveInorderTraversal(root!.left)
    result.append(root!.val)
    result += recursiveInorderTraversal(root!.right)
    return result
}

func iterativeInorderTraversal(root: TreeNode?) -> [Int] {
    if root == nil {
        return []
    }
    var result: [Int] = []
    var stack: [TreeNode] = []
    var visitedNodes: NSMutableSet = NSMutableSet.set()
    var currNode: TreeNode! = root
    while currNode != nil {
        if currNode.left != nil && !visitedNodes.containsObject(currNode.left!) {
            stack.append(currNode)
            currNode = currNode.left!
            continue
        }
        if !visitedNodes.containsObject(currNode) {
            result.append(currNode.val)
            visitedNodes.addObject(currNode)
        }
        if currNode.right != nil && !visitedNodes.containsObject(currNode.right!) {
            stack.append(currNode)
            currNode = currNode.right!
            continue
        }
        currNode = stack.count > 0 ? stack.removeLast() : nil
    }
    return result
}

let json = JSON.fromNSURL(NSURL.fileURLWithPath("testCases.json")!)
let regex = NSRegularExpression.regularExpressionWithPattern("-?\\d+|#", options: nil, error: nil)!
var timer1 = NanoTimer(), timer2 = NanoTimer()

for (index, testCase) in json {
    let c = testCase["input"].asString! as NSString
    var matches = regex.matchesInString(c, options: nil, range: NSMakeRange(0, c.length))
    var input: TreeNode?
    let uninitNode = TreeNode(val: 0)
    var queue: [TreeNode] = []
    for m in matches {
        let val = c.substringWithRange(m.rangeAtIndex(0)).toInt()
        var newNode: TreeNode?
        if val != nil {
            newNode = TreeNode(val: val!, left: uninitNode, right: uninitNode)
            queue.append(newNode!)
        }
        if input == nil {
            input = newNode
        } else {
            if queue.first!.left === uninitNode {
                queue.first!.left = newNode
            } else if queue.first!.right === uninitNode {
                queue.first!.right = newNode
                queue.removeAtIndex(0)
            }
        }
    }
    for node in queue {
        if node.left === uninitNode {
            node.left = nil
        }
        if node.right === uninitNode {
            node.right = nil
        }
    }
    
    var output = testCase["output"].asArray!.map({ c -> Int in
        return c.asInt!
    })
    
    timer1.start()
    var actualOutput1 = recursiveInorderTraversal(input)
    timer1.stop()
    
    timer2.start()
    var actualOutput2 = iterativeInorderTraversal(input)
    timer2.stop()
    
    if actualOutput1 == output && actualOutput2 == output {
        println(String(format: "test case %d --> ok", arguments: [index as Int + 1]))
    } else {
        println(String(format: "test case %d --> failed", arguments: [index as Int + 1]))
    }
}
println(String(format: "total execution time: %fs (recursively) %fs (iteratively)", arguments: [timer1.seconds, timer2.seconds]))